import requests
import json
import time

BASE_URL = "http://127.0.0.1:8000"

def optimize():
    print("--- Starting Optimization (Model Training) ---")
    try:
        response = requests.get(f"{BASE_URL}/optimize/")
        if response.status_code == 200:
            print("Optimization Success!")
            print(json.dumps(response.json(), indent=2))
        else:
            print(f"Optimization Failed: {response.status_code}")
            print(response.text)
    except Exception as e:
        print(f"Error connecting: {e}")

def predict():
    print("\n--- Testing Prediction with ML ---")
    params = {
        "time_casa": "MNC",
        "time_fora": "FUL"
    }
    try:
        response = requests.get(f"{BASE_URL}/predict/", params=params)
        if response.status_code == 200:
            print("Prediction Success!")
            data = response.json()
            print(json.dumps(data, indent=2))
            
            # Check if ML fields might have influenced the result (hard to tell directly, but we check for errors)
            if data['winner_1x2']['probability'] > 0:
                print("Probabilities generated successfully.")
        else:
            print(f"Prediction Failed: {response.status_code}")
            print(response.text)
    except Exception as e:
        print(f"Error connecting: {e}")

if __name__ == "__main__":
    # 1. First prediction (might use fallback if no model)
    predict()
    
    # 2. Train model
    optimize()
    
    # 3. Predict again (should use ML)
    predict()
