<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requireRole('admin');

// Simular lista de usuários
$db = Database::getInstance()->getConnection();
$users = $db->query("SELECT u.id, u.username, u.email, GROUP_CONCAT(r.name) as roles FROM users u LEFT JOIN user_roles ur ON u.id = ur.user_id LEFT JOIN roles r ON ur.role_id = r.id GROUP BY u.id")->fetchAll();

?>
<?php include 'views/partials/header.php'; ?>

<h2>Painel de Admin</h2>
<p>Esta página é restrita apenas para administradores.</p>

<h3>Usuários do Sistema</h3>
<table border="1" cellpadding="10" style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nome</th>
            <th>Email</th>
            <th>Roles</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $u): ?>
        <tr>
            <td><?= $u['id'] ?></td>
            <td><?= htmlspecialchars($u['username']) ?></td>
            <td><?= htmlspecialchars($u['email']) ?></td>
            <td><?= htmlspecialchars($u['roles'] ?? 'Nenhum') ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php include 'views/partials/footer.php'; ?>
