<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users');

$id = $_GET['id'] ?? null;
$permission = new Permission();
$isEdit = false;

if ($id) {
    $permission = $permission->findById($id);
    if (!$permission) {
        echo "Permissão não encontrada.";
        exit;
    }
    $isEdit = true;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $description = $_POST['description'] ?? '';
    $is_exclusive = isset($_POST['is_exclusive']) ? 1 : 0;
    
    // Security check: Only super_admin can set is_exclusive
    if (!Auth::hasRole('super_admin')) {
        $is_exclusive = 0; // Force to 0 if not super_admin
        if ($isEdit && $permission->is_exclusive) {
             // If editing an existing exclusive permission and not super_admin, prevent change?
             // Actually, non-super_admin shouldn't even see this page for exclusive permissions.
             // But for safety:
             $is_exclusive = 1; // Keep it as is if they can't change it
        }
    }

    if (empty($name)) {
        $error = "Nome é obrigatório.";
    } else {
        $success = false;
        if ($isEdit) {
            if ($permission->update($name, $description, $is_exclusive)) {
                $success = true;
            }
        } else {
            if ($permission->create($name, $description, $is_exclusive)) {
                $success = true;
            }
        }

        if ($success) {
            $_SESSION['success'] = "Permissão salva com sucesso!";
            header('Location: permissions.php');
            exit;
        } else {
            $error = "Erro ao salvar permissão.";
        }
    }
}
?>
<?php include 'views/partials/header.php'; ?>

<h2><?= $isEdit ? 'Editar Permissão' : 'Nova Permissão' ?></h2>

<?php if ($error): ?>
    <div class="alert alert-error"><?= $error ?></div>
<?php endif; ?>

<form method="POST" action="">
    <label>Nome (Slug):</label>
    <small>Ex: manage_users, edit_posts</small>
    <input type="text" name="name" value="<?= htmlspecialchars($permission->name ?? '') ?>" required>
    
    <label>Descrição:</label>
    <textarea name="description" style="width: 100%; height: 60px; margin-bottom: 10px;"><?= htmlspecialchars($permission->description ?? '') ?></textarea>
    
    <?php if (Auth::hasRole('super_admin')): ?>
        <div style="margin-bottom: 20px;">
            <label style="display: inline;">
                <input type="checkbox" name="is_exclusive" value="1" <?= ($permission->is_exclusive ?? false) ? 'checked' : '' ?> style="width: auto;">
                <strong>Permissão Exclusiva (Visível apenas para Super Admin)</strong>
            </label>
        </div>
    <?php endif; ?>
    
    <button type="submit" style="margin-top: 20px;">Salvar</button>
</form>

<div style="margin-top: 20px;">
    <a href="permissions.php">Voltar para Lista</a>
</div>

<?php include 'views/partials/footer.php'; ?>
