<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users');

$id = $_GET['id'] ?? null;

if (!$id) {
    header('Location: roles.php');
    exit;
}

$role = new Role();
$role->findById($id);

if (!$role->id) {
    $_SESSION['error'] = "Papel não encontrado.";
    header('Location: roles.php');
    exit;
}

// Security Check: Prevent deletion of protected roles
if (in_array($role->name, ['admin', 'super_admin', 'user'])) {
    header('HTTP/1.0 403 Forbidden');
    echo "Acesso negado. Você não pode excluir este papel protegido.";
    exit;
}

if ($role->delete()) {
    $_SESSION['success'] = "Papel excluído com sucesso!";
} else {
    $_SESSION['error'] = "Erro ao excluir papel. Pode haver usuários associados a ele.";
}

header('Location: roles.php');
exit;
