<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users'); // Assuming managing roles is restricted to user managers or similar

$roles = Role::getAll();
?>
<?php include 'views/partials/header.php'; ?>

<h2>Gerenciar Papéis (Roles)</h2>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
    <?php unset($_SESSION['success']); ?>
<?php endif; ?>

<?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-error"><?= $_SESSION['error'] ?></div>
    <?php unset($_SESSION['error']); ?>
<?php endif; ?>

<div style="margin-bottom: 20px;">
    <a href="role_edit.php" class="btn">Criar Novo Papel</a>
</div>

<table border="1" cellpadding="10" style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th>Nome</th>
            <th>Descrição</th>
            <th>Ações</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($roles as $role): ?>
            <?php
                // Check if the role is protected
                $isProtected = in_array($role->name, ['admin', 'super_admin']);
                $canEdit = true;
                if ($isProtected && !Auth::hasRole('super_admin')) {
                    $canEdit = false;
                }
            ?>
            <?php if ($canEdit): ?>
                <tr>
                    <td><?= htmlspecialchars($role->name) ?></td>
                    <td><?= htmlspecialchars($role->description) ?></td>
                    <td>               
                        <a href="role_edit.php?id=<?= $role->id ?>">Editar</a>
                        <?php if (!in_array($role->name, ['user'])): ?>
                            | <a href="role_delete.php?id=<?= $role->id ?>" onclick="return confirm('Tem certeza que deseja excluir este papel?');" style="color: red;">Excluir</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; ?>
    </tbody>
</table>

<div style="margin-top: 20px;">
    <a href="dashboard.php">Voltar ao Dashboard</a>
</div>

<?php include 'views/partials/footer.php'; ?>
