<?php

class Auth {
    public static function init() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    public static function login($email, $password) {
        self::init();
        $user = new User();
        if ($user->findByEmail($email)) {
            if (password_verify($password, $user->password)) {
                $_SESSION['user_id'] = $user->id;
                $_SESSION['user_roles'] = $user->getRoles();
                $_SESSION['user_permissions'] = $user->getPermissions();
                return true;
            }
        }
        return false;
    }

    public static function logout() {
        self::init();
        session_unset();
        session_destroy();
    }

    public static function user() {
        self::init();
        if (isset($_SESSION['user_id'])) {
            $user = new User();
            return $user->findById($_SESSION['user_id']);
        }
        return null;
    }

    public static function check() {
        self::init();
        return isset($_SESSION['user_id']);
    }

    public static function hasRole($role) {
        self::init();
        return isset($_SESSION['user_roles']) && in_array($role, $_SESSION['user_roles']);
    }

    public static function hasPermission($permission) {
        self::init();
        // Removed hardcoded admin check to respect DB permissions
        return isset($_SESSION['user_permissions']) && in_array($permission, $_SESSION['user_permissions']);
    }

    public static function requireRole($role) {
        if (!self::hasRole($role)) {
            header('HTTP/1.0 403 Forbidden');
            echo "Acesso negado. Requer papel: $role";
            exit;
        }
    }

    public static function requirePermission($permission) {
        if (!self::hasPermission($permission)) {
            header('HTTP/1.0 403 Forbidden');
            echo "Acesso negado. Requer permissão: $permission";
            exit;
        }
    }
    
    public static function requireLogin() {
        if (!self::check()) {
            header('Location: login.php');
            exit;
        }
    }
}
