<?php

class Role {
    private $db;
    public $id;
    public $name;
    public $description;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public static function getAll() {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->query("SELECT * FROM roles");
        $roles = [];
        while ($row = $stmt->fetch()) {
            $role = new Role();
            $role->id = $row['id'];
            $role->name = $row['name'];
            $role->description = $row['description'];
            $roles[] = $role;
        }
        return $roles;
    }

    public function findById($id) {
        $stmt = $this->db->prepare("SELECT * FROM roles WHERE id = :id LIMIT 1");
        $stmt->execute(['id' => $id]);
        $row = $stmt->fetch();
        if ($row) {
            $this->id = $row['id'];
            $this->name = $row['name'];
            $this->description = $row['description'];
            return $this;
        }
        return null;
    }

    public function create($name, $description = '') {
        try {
            $stmt = $this->db->prepare("INSERT INTO roles (name, description) VALUES (:name, :description)");
            $stmt->execute(['name' => $name, 'description' => $description]);
            $this->id = $this->db->lastInsertId();
            $this->name = $name;
            $this->description = $description;
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function update($name, $description = '') {
        try {
            $stmt = $this->db->prepare("UPDATE roles SET name = :name, description = :description WHERE id = :id");
            $stmt->execute(['name' => $name, 'description' => $description, 'id' => $this->id]);
            $this->name = $name;
            $this->description = $description;
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function delete() {
        try {
            $stmt = $this->db->prepare("DELETE FROM roles WHERE id = :id");
            return $stmt->execute(['id' => $this->id]);
        } catch (PDOException $e) {
            return false;
        }
    }

    public function getPermissions() {
        $stmt = $this->db->prepare("SELECT permission_id FROM role_permissions WHERE role_id = :role_id");
        $stmt->execute(['role_id' => $this->id]);
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }

    public function syncPermissions($permissionIds) {
        try {
            $this->db->beginTransaction();
            
            // Remove existing permissions
            $stmt = $this->db->prepare("DELETE FROM role_permissions WHERE role_id = :role_id");
            $stmt->execute(['role_id' => $this->id]);
            
            // Add new permissions
            if (!empty($permissionIds)) {
                $insertStmt = $this->db->prepare("INSERT INTO role_permissions (role_id, permission_id) VALUES (:role_id, :permission_id)");
                foreach ($permissionIds as $permId) {
                    $insertStmt->execute(['role_id' => $this->id, 'permission_id' => $permId]);
                }
            }
            
            $this->db->commit();
            return true;
        } catch (PDOException $e) {
            $this->db->rollBack();
            return false;
        }
    }
}
