<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users');

$users = User::getAll();
?>
<?php include 'views/partials/header.php'; ?>

<h2>Gerenciar Usuários</h2>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
    <?php unset($_SESSION['success']); ?>
<?php endif; ?>

<table border="1" cellpadding="10" style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nome</th>
            <th>Email</th>
            <th>Roles</th>
            <th>Ações</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $u): ?>
        <tr>
            <td><?= $u->id ?></td>
            <td><?= htmlspecialchars($u->username) ?></td>
            <td><?= htmlspecialchars($u->email) ?></td>
            <td><?= implode(', ', $u->getRoles()) ?></td>
            <td>
                <a href="user_edit.php?id=<?= $u->id ?>">Editar</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<div style="margin-top: 20px;">
    <a href="dashboard.php">Voltar ao Dashboard</a>
</div>

<?php include 'views/partials/footer.php'; ?>
